package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListPoliciesForTargetResponse(
    policies: Option[
      Iterable[io.github.vigoo.zioaws.organizations.model.PolicySummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetResponse = {
    import ListPoliciesForTargetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetResponse
      .builder()
      .optionallyWith(
        policies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policies)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListPoliciesForTargetResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListPoliciesForTargetResponse
      .wrap(buildAwsValue())
}
object ListPoliciesForTargetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListPoliciesForTargetResponse =
      io.github.vigoo.zioaws.organizations.model.ListPoliciesForTargetResponse(
        policiesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def policiesValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly]
    ]
    def nextTokenValue: Option[NextToken]
    def policies: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly
    ]] = AwsError.unwrapOptionField("policies", policiesValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetResponse
  ) extends io.github.vigoo.zioaws.organizations.model.ListPoliciesForTargetResponse.ReadOnly {
    override def policiesValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly]
    ] = scala
      .Option(impl.policies())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.PolicySummary.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetResponse
  ): io.github.vigoo.zioaws.organizations.model.ListPoliciesForTargetResponse.ReadOnly =
    new Wrapper(impl)
}
