package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListOrganizationalUnitsForParentResponse(
    organizationalUnits: Option[
      Iterable[io.github.vigoo.zioaws.organizations.model.OrganizationalUnit]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentResponse = {
    import ListOrganizationalUnitsForParentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentResponse
      .builder()
      .optionallyWith(
        organizationalUnits.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.organizationalUnits)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListOrganizationalUnitsForParentResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListOrganizationalUnitsForParentResponse
      .wrap(buildAwsValue())
}
object ListOrganizationalUnitsForParentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListOrganizationalUnitsForParentResponse =
      io.github.vigoo.zioaws.organizations.model
        .ListOrganizationalUnitsForParentResponse(
          organizationalUnitsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextTokenValue.map(value => value)
        )
    def organizationalUnitsValue: Option[List[
      io.github.vigoo.zioaws.organizations.model.OrganizationalUnit.ReadOnly
    ]]
    def nextTokenValue: Option[NextToken]
    def organizationalUnits: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.OrganizationalUnit.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "organizationalUnits",
      organizationalUnitsValue
    )
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentResponse
  ) extends io.github.vigoo.zioaws.organizations.model.ListOrganizationalUnitsForParentResponse.ReadOnly {
    override def organizationalUnitsValue: Option[List[
      io.github.vigoo.zioaws.organizations.model.OrganizationalUnit.ReadOnly
    ]] = scala
      .Option(impl.organizationalUnits())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.OrganizationalUnit
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentResponse
  ): io.github.vigoo.zioaws.organizations.model.ListOrganizationalUnitsForParentResponse.ReadOnly =
    new Wrapper(impl)
}
