package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListHandshakesForOrganizationResponse(
    handshakes: Option[
      Iterable[io.github.vigoo.zioaws.organizations.model.Handshake]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationResponse = {
    import ListHandshakesForOrganizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationResponse
      .builder()
      .optionallyWith(
        handshakes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.handshakes)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListHandshakesForOrganizationResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListHandshakesForOrganizationResponse
      .wrap(buildAwsValue())
}
object ListHandshakesForOrganizationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListHandshakesForOrganizationResponse =
      io.github.vigoo.zioaws.organizations.model
        .ListHandshakesForOrganizationResponse(
          handshakesValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextTokenValue.map(value => value)
        )
    def handshakesValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly]
    ]
    def nextTokenValue: Option[NextToken]
    def handshakes: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly
    ]] = AwsError.unwrapOptionField("handshakes", handshakesValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationResponse
  ) extends io.github.vigoo.zioaws.organizations.model.ListHandshakesForOrganizationResponse.ReadOnly {
    override def handshakesValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly]
    ] = scala
      .Option(impl.handshakes())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.Handshake.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationResponse
  ): io.github.vigoo.zioaws.organizations.model.ListHandshakesForOrganizationResponse.ReadOnly =
    new Wrapper(impl)
}
