package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListDelegatedServicesForAccountResponse(
    delegatedServices: Option[
      Iterable[io.github.vigoo.zioaws.organizations.model.DelegatedService]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountResponse = {
    import ListDelegatedServicesForAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountResponse
      .builder()
      .optionallyWith(
        delegatedServices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.delegatedServices)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListDelegatedServicesForAccountResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListDelegatedServicesForAccountResponse
      .wrap(buildAwsValue())
}
object ListDelegatedServicesForAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListDelegatedServicesForAccountResponse =
      io.github.vigoo.zioaws.organizations.model
        .ListDelegatedServicesForAccountResponse(
          delegatedServicesValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextTokenValue.map(value => value)
        )
    def delegatedServicesValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.DelegatedService.ReadOnly]
    ]
    def nextTokenValue: Option[NextToken]
    def delegatedServices: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.DelegatedService.ReadOnly
    ]] = AwsError.unwrapOptionField("delegatedServices", delegatedServicesValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountResponse
  ) extends io.github.vigoo.zioaws.organizations.model.ListDelegatedServicesForAccountResponse.ReadOnly {
    override def delegatedServicesValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.DelegatedService.ReadOnly]
    ] = scala
      .Option(impl.delegatedServices())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.DelegatedService.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountResponse
  ): io.github.vigoo.zioaws.organizations.model.ListDelegatedServicesForAccountResponse.ReadOnly =
    new Wrapper(impl)
}
