package io.github.vigoo.zioaws.organizations.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  MaxResults,
  NextToken
}
import scala.jdk.CollectionConverters.*
final case class ListCreateAccountStatusRequest(
    states: Option[
      Iterable[io.github.vigoo.zioaws.organizations.model.CreateAccountState]
    ] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusRequest = {
    import ListCreateAccountStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusRequest
      .builder()
      .optionallyWith(
        states.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statesWithStrings)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListCreateAccountStatusRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListCreateAccountStatusRequest
      .wrap(buildAwsValue())
}
object ListCreateAccountStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListCreateAccountStatusRequest =
      io.github.vigoo.zioaws.organizations.model.ListCreateAccountStatusRequest(
        statesValue.map(value => value),
        nextTokenValue.map(value => value),
        maxResultsValue.map(value => value)
      )
    def statesValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.CreateAccountState]
    ]
    def nextTokenValue: Option[NextToken]
    def maxResultsValue: Option[MaxResults]
    def states: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.CreateAccountState
    ]] = AwsError.unwrapOptionField("states", statesValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusRequest
  ) extends io.github.vigoo.zioaws.organizations.model.ListCreateAccountStatusRequest.ReadOnly {
    override def statesValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.CreateAccountState]
    ] = scala
      .Option(impl.states())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.CreateAccountState
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusRequest
  ): io.github.vigoo.zioaws.organizations.model.ListCreateAccountStatusRequest.ReadOnly =
    new Wrapper(impl)
}
