package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListChildrenResponse(
    children: Option[
      Iterable[io.github.vigoo.zioaws.organizations.model.Child]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListChildrenResponse = {
    import ListChildrenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListChildrenResponse
      .builder()
      .optionallyWith(
        children.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.children)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListChildrenResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListChildrenResponse
      .wrap(buildAwsValue())
}
object ListChildrenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListChildrenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListChildrenResponse =
      io.github.vigoo.zioaws.organizations.model.ListChildrenResponse(
        childrenValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def childrenValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.Child.ReadOnly]
    ]
    def nextTokenValue: Option[NextToken]
    def children: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.Child.ReadOnly
    ]] = AwsError.unwrapOptionField("children", childrenValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListChildrenResponse
  ) extends io.github.vigoo.zioaws.organizations.model.ListChildrenResponse.ReadOnly {
    override def childrenValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.Child.ReadOnly]
    ] = scala
      .Option(impl.children())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.Child.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListChildrenResponse
  ): io.github.vigoo.zioaws.organizations.model.ListChildrenResponse.ReadOnly =
    new Wrapper(impl)
}
