package io.github.vigoo.zioaws.organizations.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  MaxResults,
  NextToken,
  ParentId
}
import scala.jdk.CollectionConverters.*
final case class ListChildrenRequest(
    parentId: ParentId,
    childType: io.github.vigoo.zioaws.organizations.model.ChildType,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListChildrenRequest = {
    import ListChildrenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListChildrenRequest
      .builder()
      .parentId(parentId: java.lang.String)
      .childType(childType.unwrap)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListChildrenRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListChildrenRequest
      .wrap(buildAwsValue())
}
object ListChildrenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListChildrenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListChildrenRequest =
      io.github.vigoo.zioaws.organizations.model.ListChildrenRequest(
        parentIdValue,
        childTypeValue,
        nextTokenValue.map(value => value),
        maxResultsValue.map(value => value)
      )
    def parentIdValue: ParentId
    def childTypeValue: io.github.vigoo.zioaws.organizations.model.ChildType
    def nextTokenValue: Option[NextToken]
    def maxResultsValue: Option[MaxResults]
    def parentId: ZIO[Any, Nothing, ParentId] = ZIO.succeed(parentIdValue)
    def childType: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.organizations.model.ChildType
    ] = ZIO.succeed(childTypeValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListChildrenRequest
  ) extends io.github.vigoo.zioaws.organizations.model.ListChildrenRequest.ReadOnly {
    override def parentIdValue: ParentId = impl.parentId(): ParentId
    override def childTypeValue
        : io.github.vigoo.zioaws.organizations.model.ChildType =
      io.github.vigoo.zioaws.organizations.model.ChildType
        .wrap(impl.childType())
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListChildrenRequest
  ): io.github.vigoo.zioaws.organizations.model.ListChildrenRequest.ReadOnly =
    new Wrapper(impl)
}
