package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.HandshakeNotes
import scala.jdk.CollectionConverters.*
final case class InviteAccountToOrganizationRequest(
    target: io.github.vigoo.zioaws.organizations.model.HandshakeParty,
    notes: Option[HandshakeNotes] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.organizations.model.Tag]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationRequest = {
    import InviteAccountToOrganizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationRequest
      .builder()
      .target(target.buildAwsValue())
      .optionallyWith(notes.map(value => value: java.lang.String))(_.notes)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.InviteAccountToOrganizationRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.InviteAccountToOrganizationRequest
      .wrap(buildAwsValue())
}
object InviteAccountToOrganizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.InviteAccountToOrganizationRequest =
      io.github.vigoo.zioaws.organizations.model
        .InviteAccountToOrganizationRequest(
          targetValue.editable,
          notesValue.map(value => value),
          tagsValue.map(value =>
            value.map { item =>
              item.editable
            }
          )
        )
    def targetValue
        : io.github.vigoo.zioaws.organizations.model.HandshakeParty.ReadOnly
    def notesValue: Option[HandshakeNotes]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly]]
    def target: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.organizations.model.HandshakeParty.ReadOnly
    ] = ZIO.succeed(targetValue)
    def notes: ZIO[Any, AwsError, HandshakeNotes] =
      AwsError.unwrapOptionField("notes", notesValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationRequest
  ) extends io.github.vigoo.zioaws.organizations.model.InviteAccountToOrganizationRequest.ReadOnly {
    override def targetValue
        : io.github.vigoo.zioaws.organizations.model.HandshakeParty.ReadOnly =
      io.github.vigoo.zioaws.organizations.model.HandshakeParty
        .wrap(impl.target())
    override def notesValue: Option[HandshakeNotes] =
      scala.Option(impl.notes()).map(value => value: HandshakeNotes)
    override def tagsValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly]
    ] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationRequest
  ): io.github.vigoo.zioaws.organizations.model.InviteAccountToOrganizationRequest.ReadOnly =
    new Wrapper(impl)
}
