package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.HandshakeResourceValue
import scala.jdk.CollectionConverters.*
final case class HandshakeResource(
    value: Option[HandshakeResourceValue] = None,
    `type`: Option[
      io.github.vigoo.zioaws.organizations.model.HandshakeResourceType
    ] = None,
    resources: Option[
      Iterable[io.github.vigoo.zioaws.organizations.model.HandshakeResource]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.HandshakeResource = {
    import HandshakeResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.HandshakeResource
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resources)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.HandshakeResource.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.HandshakeResource
      .wrap(buildAwsValue())
}
object HandshakeResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.HandshakeResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.organizations.model.HandshakeResource =
      io.github.vigoo.zioaws.organizations.model.HandshakeResource(
        valueValue.map(value => value),
        typeValue.map(value => value),
        resourcesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def valueValue: Option[HandshakeResourceValue]
    def typeValue: Option[
      io.github.vigoo.zioaws.organizations.model.HandshakeResourceType
    ]
    def resourcesValue: Option[List[
      io.github.vigoo.zioaws.organizations.model.HandshakeResource.ReadOnly
    ]]
    def value: ZIO[Any, AwsError, HandshakeResourceValue] =
      AwsError.unwrapOptionField("value", valueValue)
    def `type`: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.HandshakeResourceType
    ] = AwsError.unwrapOptionField("type", typeValue)
    def resources: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.HandshakeResource.ReadOnly
    ]] = AwsError.unwrapOptionField("resources", resourcesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.HandshakeResource
  ) extends io.github.vigoo.zioaws.organizations.model.HandshakeResource.ReadOnly {
    override def valueValue: Option[HandshakeResourceValue] =
      scala.Option(impl.value()).map(value => value: HandshakeResourceValue)
    override def typeValue: Option[
      io.github.vigoo.zioaws.organizations.model.HandshakeResourceType
    ] = scala
      .Option(impl.`type`())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.HandshakeResourceType
          .wrap(value)
      )
    override def resourcesValue: Option[List[
      io.github.vigoo.zioaws.organizations.model.HandshakeResource.ReadOnly
    ]] = scala
      .Option(impl.resources())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.HandshakeResource
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.HandshakeResource
  ): io.github.vigoo.zioaws.organizations.model.HandshakeResource.ReadOnly =
    new Wrapper(impl)
}
