package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.organizations.model.primitives.ServicePrincipal
import scala.jdk.CollectionConverters.*
final case class EnableAwsServiceAccessRequest(
    servicePrincipal: ServicePrincipal
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.EnableAwsServiceAccessRequest = {
    import EnableAwsServiceAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.EnableAwsServiceAccessRequest
      .builder()
      .servicePrincipal(servicePrincipal: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.EnableAwsServiceAccessRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.EnableAwsServiceAccessRequest
      .wrap(buildAwsValue())
}
object EnableAwsServiceAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.EnableAwsServiceAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.EnableAwsServiceAccessRequest =
      io.github.vigoo.zioaws.organizations.model
        .EnableAwsServiceAccessRequest(servicePrincipalValue)
    def servicePrincipalValue: ServicePrincipal
    def servicePrincipal: ZIO[Any, Nothing, ServicePrincipal] =
      ZIO.succeed(servicePrincipalValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.EnableAwsServiceAccessRequest
  ) extends io.github.vigoo.zioaws.organizations.model.EnableAwsServiceAccessRequest.ReadOnly {
    override def servicePrincipalValue: ServicePrincipal =
      impl.servicePrincipal(): ServicePrincipal
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.EnableAwsServiceAccessRequest
  ): io.github.vigoo.zioaws.organizations.model.EnableAwsServiceAccessRequest.ReadOnly =
    new Wrapper(impl)
}
