package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DisablePolicyTypeResponse(
    root: Option[io.github.vigoo.zioaws.organizations.model.Root] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.DisablePolicyTypeResponse = {
    import DisablePolicyTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DisablePolicyTypeResponse
      .builder()
      .optionallyWith(root.map(value => value.buildAwsValue()))(_.root)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.DisablePolicyTypeResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.DisablePolicyTypeResponse
      .wrap(buildAwsValue())
}
object DisablePolicyTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.DisablePolicyTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.DisablePolicyTypeResponse =
      io.github.vigoo.zioaws.organizations.model
        .DisablePolicyTypeResponse(rootValue.map(value => value.editable))
    def rootValue
        : Option[io.github.vigoo.zioaws.organizations.model.Root.ReadOnly]
    def root: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.Root.ReadOnly
    ] = AwsError.unwrapOptionField("root", rootValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.DisablePolicyTypeResponse
  ) extends io.github.vigoo.zioaws.organizations.model.DisablePolicyTypeResponse.ReadOnly {
    override def rootValue
        : Option[io.github.vigoo.zioaws.organizations.model.Root.ReadOnly] =
      scala
        .Option(impl.root())
        .map(value =>
          io.github.vigoo.zioaws.organizations.model.Root.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.DisablePolicyTypeResponse
  ): io.github.vigoo.zioaws.organizations.model.DisablePolicyTypeResponse.ReadOnly =
    new Wrapper(impl)
}
