package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.organizations.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class DescribeAccountRequest(accountId: AccountId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.DescribeAccountRequest = {
    import DescribeAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DescribeAccountRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.DescribeAccountRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.DescribeAccountRequest
      .wrap(buildAwsValue())
}
object DescribeAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.DescribeAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.DescribeAccountRequest =
      io.github.vigoo.zioaws.organizations.model
        .DescribeAccountRequest(accountIdValue)
    def accountIdValue: AccountId
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.DescribeAccountRequest
  ) extends io.github.vigoo.zioaws.organizations.model.DescribeAccountRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.DescribeAccountRequest
  ): io.github.vigoo.zioaws.organizations.model.DescribeAccountRequest.ReadOnly =
    new Wrapper(impl)
}
