package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
sealed trait CreateAccountFailureReason {
  def unwrap: software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason
}
object CreateAccountFailureReason {
  def wrap(
      value: software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason
  ): io.github.vigoo.zioaws.organizations.model.CreateAccountFailureReason =
    value match {
      case software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.ACCOUNT_LIMIT_EXCEEDED =>
        val r = ACCOUNT_LIMIT_EXCEEDED
        r
      case software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.EMAIL_ALREADY_EXISTS =>
        val r = EMAIL_ALREADY_EXISTS
        r
      case software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.INVALID_ADDRESS =>
        val r = INVALID_ADDRESS
        r
      case software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.INVALID_EMAIL =>
        val r = INVALID_EMAIL
        r
      case software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.CONCURRENT_ACCOUNT_MODIFICATION =>
        val r = CONCURRENT_ACCOUNT_MODIFICATION
        r
      case software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.INTERNAL_FAILURE =>
        val r = INTERNAL_FAILURE
        r
      case software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.GOVCLOUD_ACCOUNT_ALREADY_EXISTS =>
        val r = GOVCLOUD_ACCOUNT_ALREADY_EXISTS
        r
      case software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.MISSING_BUSINESS_VALIDATION =>
        val r = MISSING_BUSINESS_VALIDATION
        r
      case software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.FAILED_BUSINESS_VALIDATION =>
        val r = FAILED_BUSINESS_VALIDATION
        r
      case software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.PENDING_BUSINESS_VALIDATION =>
        val r = PENDING_BUSINESS_VALIDATION
        r
      case software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.INVALID_IDENTITY_FOR_BUSINESS_VALIDATION =>
        val r = INVALID_IDENTITY_FOR_BUSINESS_VALIDATION
        r
      case software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.UNKNOWN_BUSINESS_VALIDATION =>
        val r = UNKNOWN_BUSINESS_VALIDATION
        r
      case software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.MISSING_PAYMENT_INSTRUMENT =>
        val r = MISSING_PAYMENT_INSTRUMENT
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.organizations.model.CreateAccountFailureReason {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason =
      software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCOUNT_LIMIT_EXCEEDED
      extends io.github.vigoo.zioaws.organizations.model.CreateAccountFailureReason {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason =
      software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.ACCOUNT_LIMIT_EXCEEDED
  }
  case object EMAIL_ALREADY_EXISTS
      extends io.github.vigoo.zioaws.organizations.model.CreateAccountFailureReason {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason =
      software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.EMAIL_ALREADY_EXISTS
  }
  case object INVALID_ADDRESS
      extends io.github.vigoo.zioaws.organizations.model.CreateAccountFailureReason {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason =
      software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.INVALID_ADDRESS
  }
  case object INVALID_EMAIL
      extends io.github.vigoo.zioaws.organizations.model.CreateAccountFailureReason {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason =
      software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.INVALID_EMAIL
  }
  case object CONCURRENT_ACCOUNT_MODIFICATION
      extends io.github.vigoo.zioaws.organizations.model.CreateAccountFailureReason {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason =
      software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.CONCURRENT_ACCOUNT_MODIFICATION
  }
  case object INTERNAL_FAILURE
      extends io.github.vigoo.zioaws.organizations.model.CreateAccountFailureReason {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason =
      software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.INTERNAL_FAILURE
  }
  case object GOVCLOUD_ACCOUNT_ALREADY_EXISTS
      extends io.github.vigoo.zioaws.organizations.model.CreateAccountFailureReason {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason =
      software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.GOVCLOUD_ACCOUNT_ALREADY_EXISTS
  }
  case object MISSING_BUSINESS_VALIDATION
      extends io.github.vigoo.zioaws.organizations.model.CreateAccountFailureReason {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason =
      software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.MISSING_BUSINESS_VALIDATION
  }
  case object FAILED_BUSINESS_VALIDATION
      extends io.github.vigoo.zioaws.organizations.model.CreateAccountFailureReason {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason =
      software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.FAILED_BUSINESS_VALIDATION
  }
  case object PENDING_BUSINESS_VALIDATION
      extends io.github.vigoo.zioaws.organizations.model.CreateAccountFailureReason {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason =
      software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.PENDING_BUSINESS_VALIDATION
  }
  case object INVALID_IDENTITY_FOR_BUSINESS_VALIDATION
      extends io.github.vigoo.zioaws.organizations.model.CreateAccountFailureReason {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason =
      software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.INVALID_IDENTITY_FOR_BUSINESS_VALIDATION
  }
  case object UNKNOWN_BUSINESS_VALIDATION
      extends io.github.vigoo.zioaws.organizations.model.CreateAccountFailureReason {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason =
      software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.UNKNOWN_BUSINESS_VALIDATION
  }
  case object MISSING_PAYMENT_INSTRUMENT
      extends io.github.vigoo.zioaws.organizations.model.CreateAccountFailureReason {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason =
      software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason.MISSING_PAYMENT_INSTRUMENT
  }
}
