package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.ChildId
import scala.jdk.CollectionConverters.*
final case class Child(
    id: Option[ChildId] = None,
    `type`: Option[io.github.vigoo.zioaws.organizations.model.ChildType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.Child = {
    import Child.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.Child
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.organizations.model.Child.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.Child.wrap(buildAwsValue())
}
object Child {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.Child
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.organizations.model.Child =
      io.github.vigoo.zioaws.organizations.model
        .Child(idValue.map(value => value), typeValue.map(value => value))
    def idValue: Option[ChildId]
    def typeValue: Option[io.github.vigoo.zioaws.organizations.model.ChildType]
    def id: ZIO[Any, AwsError, ChildId] =
      AwsError.unwrapOptionField("id", idValue)
    def `type`: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.ChildType
    ] = AwsError.unwrapOptionField("type", typeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.Child
  ) extends io.github.vigoo.zioaws.organizations.model.Child.ReadOnly {
    override def idValue: Option[ChildId] =
      scala.Option(impl.id()).map(value => value: ChildId)
    override def typeValue
        : Option[io.github.vigoo.zioaws.organizations.model.ChildType] = scala
      .Option(impl.`type`())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.ChildType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.Child
  ): io.github.vigoo.zioaws.organizations.model.Child.ReadOnly = new Wrapper(
    impl
  )
}
