package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AcceptHandshakeResponse(
    handshake: Option[io.github.vigoo.zioaws.organizations.model.Handshake] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.AcceptHandshakeResponse = {
    import AcceptHandshakeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.AcceptHandshakeResponse
      .builder()
      .optionallyWith(handshake.map(value => value.buildAwsValue()))(
        _.handshake
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.AcceptHandshakeResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.AcceptHandshakeResponse
      .wrap(buildAwsValue())
}
object AcceptHandshakeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.AcceptHandshakeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.AcceptHandshakeResponse =
      io.github.vigoo.zioaws.organizations.model
        .AcceptHandshakeResponse(handshakeValue.map(value => value.editable))
    def handshakeValue
        : Option[io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly]
    def handshake: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly
    ] = AwsError.unwrapOptionField("handshake", handshakeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.AcceptHandshakeResponse
  ) extends io.github.vigoo.zioaws.organizations.model.AcceptHandshakeResponse.ReadOnly {
    override def handshakeValue: Option[
      io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly
    ] = scala
      .Option(impl.handshake())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.Handshake.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.AcceptHandshakeResponse
  ): io.github.vigoo.zioaws.organizations.model.AcceptHandshakeResponse.ReadOnly =
    new Wrapper(impl)
}
