package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  AwsManagedPolicy,
  PolicyArn,
  PolicyName,
  PolicyDescription,
  PolicyId
}
import scala.jdk.CollectionConverters.*
final case class PolicySummary(
    id: Option[PolicyId] = None,
    arn: Option[PolicyArn] = None,
    name: Option[PolicyName] = None,
    description: Option[PolicyDescription] = None,
    `type`: Option[io.github.vigoo.zioaws.organizations.model.PolicyType] =
      None,
    awsManaged: Option[AwsManagedPolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.PolicySummary = {
    import PolicySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.PolicySummary
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(awsManaged.map(value => value: java.lang.Boolean))(
        _.awsManaged
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.PolicySummary
      .wrap(buildAwsValue())
}
object PolicySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.PolicySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.organizations.model.PolicySummary =
      io.github.vigoo.zioaws.organizations.model.PolicySummary(
        idValue.map(value => value),
        arnValue.map(value => value),
        nameValue.map(value => value),
        descriptionValue.map(value => value),
        typeValue.map(value => value),
        awsManagedValue.map(value => value)
      )
    def idValue: Option[PolicyId]
    def arnValue: Option[PolicyArn]
    def nameValue: Option[PolicyName]
    def descriptionValue: Option[PolicyDescription]
    def typeValue: Option[io.github.vigoo.zioaws.organizations.model.PolicyType]
    def awsManagedValue: Option[AwsManagedPolicy]
    def id: ZIO[Any, AwsError, PolicyId] =
      AwsError.unwrapOptionField("id", idValue)
    def arn: ZIO[Any, AwsError, PolicyArn] =
      AwsError.unwrapOptionField("arn", arnValue)
    def name: ZIO[Any, AwsError, PolicyName] =
      AwsError.unwrapOptionField("name", nameValue)
    def description: ZIO[Any, AwsError, PolicyDescription] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def `type`: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.PolicyType
    ] = AwsError.unwrapOptionField("type", typeValue)
    def awsManaged: ZIO[Any, AwsError, AwsManagedPolicy] =
      AwsError.unwrapOptionField("awsManaged", awsManagedValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.PolicySummary
  ) extends io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly {
    override def idValue: Option[PolicyId] =
      scala.Option(impl.id()).map(value => value: PolicyId)
    override def arnValue: Option[PolicyArn] =
      scala.Option(impl.arn()).map(value => value: PolicyArn)
    override def nameValue: Option[PolicyName] =
      scala.Option(impl.name()).map(value => value: PolicyName)
    override def descriptionValue: Option[PolicyDescription] =
      scala.Option(impl.description()).map(value => value: PolicyDescription)
    override def typeValue
        : Option[io.github.vigoo.zioaws.organizations.model.PolicyType] = scala
      .Option(impl.`type`())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.PolicyType.wrap(value)
      )
    override def awsManagedValue: Option[AwsManagedPolicy] =
      scala.Option(impl.awsManaged()).map(value => value: AwsManagedPolicy)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.PolicySummary
  ): io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly =
    new Wrapper(impl)
}
