package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListAwsServiceAccessForOrganizationResponse(
    enabledServicePrincipals: Option[Iterable[
      io.github.vigoo.zioaws.organizations.model.EnabledServicePrincipal
    ]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationResponse = {
    import ListAwsServiceAccessForOrganizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationResponse
      .builder()
      .optionallyWith(
        enabledServicePrincipals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.enabledServicePrincipals)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListAwsServiceAccessForOrganizationResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListAwsServiceAccessForOrganizationResponse
      .wrap(buildAwsValue())
}
object ListAwsServiceAccessForOrganizationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListAwsServiceAccessForOrganizationResponse =
      io.github.vigoo.zioaws.organizations.model
        .ListAwsServiceAccessForOrganizationResponse(
          enabledServicePrincipalsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextTokenValue.map(value => value)
        )
    def enabledServicePrincipalsValue: Option[List[
      io.github.vigoo.zioaws.organizations.model.EnabledServicePrincipal.ReadOnly
    ]]
    def nextTokenValue: Option[NextToken]
    def enabledServicePrincipals: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.EnabledServicePrincipal.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "enabledServicePrincipals",
      enabledServicePrincipalsValue
    )
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationResponse
  ) extends io.github.vigoo.zioaws.organizations.model.ListAwsServiceAccessForOrganizationResponse.ReadOnly {
    override def enabledServicePrincipalsValue: Option[List[
      io.github.vigoo.zioaws.organizations.model.EnabledServicePrincipal.ReadOnly
    ]] = scala
      .Option(impl.enabledServicePrincipals())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.EnabledServicePrincipal
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationResponse
  ): io.github.vigoo.zioaws.organizations.model.ListAwsServiceAccessForOrganizationResponse.ReadOnly =
    new Wrapper(impl)
}
