package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeCreateAccountStatusResponse(
    createAccountStatus: Option[
      io.github.vigoo.zioaws.organizations.model.CreateAccountStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusResponse = {
    import DescribeCreateAccountStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusResponse
      .builder()
      .optionallyWith(createAccountStatus.map(value => value.buildAwsValue()))(
        _.createAccountStatus
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.DescribeCreateAccountStatusResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.DescribeCreateAccountStatusResponse
      .wrap(buildAwsValue())
}
object DescribeCreateAccountStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.DescribeCreateAccountStatusResponse =
      io.github.vigoo.zioaws.organizations.model
        .DescribeCreateAccountStatusResponse(
          createAccountStatusValue.map(value => value.editable)
        )
    def createAccountStatusValue: Option[
      io.github.vigoo.zioaws.organizations.model.CreateAccountStatus.ReadOnly
    ]
    def createAccountStatus: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.CreateAccountStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "createAccountStatus",
      createAccountStatusValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusResponse
  ) extends io.github.vigoo.zioaws.organizations.model.DescribeCreateAccountStatusResponse.ReadOnly {
    override def createAccountStatusValue: Option[
      io.github.vigoo.zioaws.organizations.model.CreateAccountStatus.ReadOnly
    ] = scala
      .Option(impl.createAccountStatus())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.CreateAccountStatus
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusResponse
  ): io.github.vigoo.zioaws.organizations.model.DescribeCreateAccountStatusResponse.ReadOnly =
    new Wrapper(impl)
}
