package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CancelHandshakeResponse(
    handshake: Option[io.github.vigoo.zioaws.organizations.model.Handshake] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.CancelHandshakeResponse = {
    import CancelHandshakeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.CancelHandshakeResponse
      .builder()
      .optionallyWith(handshake.map(value => value.buildAwsValue()))(
        _.handshake
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.CancelHandshakeResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.CancelHandshakeResponse
      .wrap(buildAwsValue())
}
object CancelHandshakeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.CancelHandshakeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.CancelHandshakeResponse =
      io.github.vigoo.zioaws.organizations.model
        .CancelHandshakeResponse(handshakeValue.map(value => value.editable))
    def handshakeValue
        : Option[io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly]
    def handshake: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly
    ] = AwsError.unwrapOptionField("handshake", handshakeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.CancelHandshakeResponse
  ) extends io.github.vigoo.zioaws.organizations.model.CancelHandshakeResponse.ReadOnly {
    override def handshakeValue: Option[
      io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly
    ] = scala
      .Option(impl.handshake())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.Handshake.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.CancelHandshakeResponse
  ): io.github.vigoo.zioaws.organizations.model.CancelHandshakeResponse.ReadOnly =
    new Wrapper(impl)
}
