package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  TargetName,
  GenericArn,
  PolicyTargetId
}
import scala.jdk.CollectionConverters.*
final case class PolicyTargetSummary(
    targetId: Option[PolicyTargetId] = None,
    arn: Option[GenericArn] = None,
    name: Option[TargetName] = None,
    `type`: Option[io.github.vigoo.zioaws.organizations.model.TargetType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.PolicyTargetSummary = {
    import PolicyTargetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.PolicyTargetSummary
      .builder()
      .optionallyWith(targetId.map(value => value: java.lang.String))(
        _.targetId
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.PolicyTargetSummary.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.PolicyTargetSummary
      .wrap(buildAwsValue())
}
object PolicyTargetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.PolicyTargetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.PolicyTargetSummary =
      io.github.vigoo.zioaws.organizations.model.PolicyTargetSummary(
        targetIdValue.map(value => value),
        arnValue.map(value => value),
        nameValue.map(value => value),
        typeValue.map(value => value)
      )
    def targetIdValue: Option[PolicyTargetId]
    def arnValue: Option[GenericArn]
    def nameValue: Option[TargetName]
    def typeValue: Option[io.github.vigoo.zioaws.organizations.model.TargetType]
    def targetId: ZIO[Any, AwsError, PolicyTargetId] =
      AwsError.unwrapOptionField("targetId", targetIdValue)
    def arn: ZIO[Any, AwsError, GenericArn] =
      AwsError.unwrapOptionField("arn", arnValue)
    def name: ZIO[Any, AwsError, TargetName] =
      AwsError.unwrapOptionField("name", nameValue)
    def `type`: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.TargetType
    ] = AwsError.unwrapOptionField("type", typeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.PolicyTargetSummary
  ) extends io.github.vigoo.zioaws.organizations.model.PolicyTargetSummary.ReadOnly {
    override def targetIdValue: Option[PolicyTargetId] =
      scala.Option(impl.targetId()).map(value => value: PolicyTargetId)
    override def arnValue: Option[GenericArn] =
      scala.Option(impl.arn()).map(value => value: GenericArn)
    override def nameValue: Option[TargetName] =
      scala.Option(impl.name()).map(value => value: TargetName)
    override def typeValue
        : Option[io.github.vigoo.zioaws.organizations.model.TargetType] = scala
      .Option(impl.`type`())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.TargetType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.PolicyTargetSummary
  ): io.github.vigoo.zioaws.organizations.model.PolicyTargetSummary.ReadOnly =
    new Wrapper(impl)
}
