package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.organizations.model.primitives.ServicePrincipal
import scala.jdk.CollectionConverters.*
final case class DisableAwsServiceAccessRequest(
    servicePrincipal: ServicePrincipal
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.DisableAwsServiceAccessRequest = {
    import DisableAwsServiceAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DisableAwsServiceAccessRequest
      .builder()
      .servicePrincipal(servicePrincipal: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.DisableAwsServiceAccessRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.DisableAwsServiceAccessRequest
      .wrap(buildAwsValue())
}
object DisableAwsServiceAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.DisableAwsServiceAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.DisableAwsServiceAccessRequest =
      io.github.vigoo.zioaws.organizations.model
        .DisableAwsServiceAccessRequest(servicePrincipalValue)
    def servicePrincipalValue: ServicePrincipal
    def servicePrincipal: ZIO[Any, Nothing, ServicePrincipal] =
      ZIO.succeed(servicePrincipalValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.DisableAwsServiceAccessRequest
  ) extends io.github.vigoo.zioaws.organizations.model.DisableAwsServiceAccessRequest.ReadOnly {
    override def servicePrincipalValue: ServicePrincipal =
      impl.servicePrincipal(): ServicePrincipal
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.DisableAwsServiceAccessRequest
  ): io.github.vigoo.zioaws.organizations.model.DisableAwsServiceAccessRequest.ReadOnly =
    new Wrapper(impl)
}
