package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  PolicyContent,
  PolicyDescription,
  PolicyName,
  PolicyId
}
import scala.jdk.CollectionConverters.*
final case class UpdatePolicyRequest(
    policyId: PolicyId,
    name: Option[PolicyName] = None,
    description: Option[PolicyDescription] = None,
    content: Option[PolicyContent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.UpdatePolicyRequest = {
    import UpdatePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.UpdatePolicyRequest
      .builder()
      .policyId(policyId: java.lang.String)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(content.map(value => value: java.lang.String))(_.content)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.UpdatePolicyRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.UpdatePolicyRequest
      .wrap(buildAwsValue())
}
object UpdatePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.UpdatePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.UpdatePolicyRequest =
      io.github.vigoo.zioaws.organizations.model.UpdatePolicyRequest(
        policyIdValue,
        nameValue.map(value => value),
        descriptionValue.map(value => value),
        contentValue.map(value => value)
      )
    def policyIdValue: PolicyId
    def nameValue: Option[PolicyName]
    def descriptionValue: Option[PolicyDescription]
    def contentValue: Option[PolicyContent]
    def policyId: ZIO[Any, Nothing, PolicyId] = ZIO.succeed(policyIdValue)
    def name: ZIO[Any, AwsError, PolicyName] =
      AwsError.unwrapOptionField("name", nameValue)
    def description: ZIO[Any, AwsError, PolicyDescription] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def content: ZIO[Any, AwsError, PolicyContent] =
      AwsError.unwrapOptionField("content", contentValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.UpdatePolicyRequest
  ) extends io.github.vigoo.zioaws.organizations.model.UpdatePolicyRequest.ReadOnly {
    override def policyIdValue: PolicyId = impl.policyId(): PolicyId
    override def nameValue: Option[PolicyName] =
      scala.Option(impl.name()).map(value => value: PolicyName)
    override def descriptionValue: Option[PolicyDescription] =
      scala.Option(impl.description()).map(value => value: PolicyDescription)
    override def contentValue: Option[PolicyContent] =
      scala.Option(impl.content()).map(value => value: PolicyContent)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.UpdatePolicyRequest
  ): io.github.vigoo.zioaws.organizations.model.UpdatePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
