package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.organizations.model.primitives.OrganizationalUnitId
import scala.jdk.CollectionConverters.*
final case class DeleteOrganizationalUnitRequest(
    organizationalUnitId: OrganizationalUnitId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.DeleteOrganizationalUnitRequest = {
    import DeleteOrganizationalUnitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DeleteOrganizationalUnitRequest
      .builder()
      .organizationalUnitId(organizationalUnitId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.DeleteOrganizationalUnitRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.DeleteOrganizationalUnitRequest
      .wrap(buildAwsValue())
}
object DeleteOrganizationalUnitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.DeleteOrganizationalUnitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.DeleteOrganizationalUnitRequest =
      io.github.vigoo.zioaws.organizations.model
        .DeleteOrganizationalUnitRequest(organizationalUnitIdValue)
    def organizationalUnitIdValue: OrganizationalUnitId
    def organizationalUnitId: ZIO[Any, Nothing, OrganizationalUnitId] =
      ZIO.succeed(organizationalUnitIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.DeleteOrganizationalUnitRequest
  ) extends io.github.vigoo.zioaws.organizations.model.DeleteOrganizationalUnitRequest.ReadOnly {
    override def organizationalUnitIdValue: OrganizationalUnitId =
      impl.organizationalUnitId(): OrganizationalUnitId
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.DeleteOrganizationalUnitRequest
  ): io.github.vigoo.zioaws.organizations.model.DeleteOrganizationalUnitRequest.ReadOnly =
    new Wrapper(impl)
}
