package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdatePolicyRequest(policyId: primitives.PolicyId, name: scala.Option[primitives.PolicyName] = None, description: scala.Option[primitives.PolicyDescription] = None, content: scala.Option[primitives.PolicyContent] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.UpdatePolicyRequest = {
    import UpdatePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.UpdatePolicyRequest.builder().policyId(policyId: java.lang.String).optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(description.map(value => value: java.lang.String))(_.description).optionallyWith(content.map(value => value: java.lang.String))(_.content).build()
  }
  def asReadOnly: UpdatePolicyRequest.ReadOnly = UpdatePolicyRequest.wrap(buildAwsValue())
}
object UpdatePolicyRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.UpdatePolicyRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdatePolicyRequest = UpdatePolicyRequest(policyIdValue, nameValue.map(value => value), descriptionValue.map(value => value), contentValue.map(value => value))
    def policyIdValue: primitives.PolicyId
    def nameValue: scala.Option[primitives.PolicyName]
    def descriptionValue: scala.Option[primitives.PolicyDescription]
    def contentValue: scala.Option[primitives.PolicyContent]
    def policyId: ZIO[Any, Nothing, primitives.PolicyId] = ZIO.succeed(policyIdValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PolicyName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def description: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PolicyDescription] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("description", descriptionValue)
    def content: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PolicyContent] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("content", contentValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.UpdatePolicyRequest) extends UpdatePolicyRequest.ReadOnly {
    override def policyIdValue: primitives.PolicyId = impl.policyId(): primitives.PolicyId
    override def nameValue: scala.Option[primitives.PolicyName] = scala.Option(impl.name()).map(value => value: primitives.PolicyName)
    override def descriptionValue: scala.Option[primitives.PolicyDescription] = scala.Option(impl.description()).map(value => value: primitives.PolicyDescription)
    override def contentValue: scala.Option[primitives.PolicyContent] = scala.Option(impl.content()).map(value => value: primitives.PolicyContent)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.UpdatePolicyRequest): ReadOnly = new Wrapper(impl)
}