package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait PolicyType { def unwrap: software.amazon.awssdk.services.organizations.model.PolicyType }
object PolicyType {
  def wrap(value: software.amazon.awssdk.services.organizations.model.PolicyType): PolicyType = value match {
    case software.amazon.awssdk.services.organizations.model.PolicyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.organizations.model.PolicyType.SERVICE_CONTROL_POLICY =>
      val r = SERVICE_CONTROL_POLICY
      r
    case software.amazon.awssdk.services.organizations.model.PolicyType.TAG_POLICY =>
      val r = TAG_POLICY
      r
    case software.amazon.awssdk.services.organizations.model.PolicyType.BACKUP_POLICY =>
      val r = BACKUP_POLICY
      r
    case software.amazon.awssdk.services.organizations.model.PolicyType.AISERVICES_OPT_OUT_POLICY =>
      val r = AISERVICES_OPT_OUT_POLICY
      r
  }
  case object unknownToSdkVersion extends PolicyType { override def unwrap: software.amazon.awssdk.services.organizations.model.PolicyType = software.amazon.awssdk.services.organizations.model.PolicyType.UNKNOWN_TO_SDK_VERSION }
  case object SERVICE_CONTROL_POLICY extends PolicyType { override def unwrap: software.amazon.awssdk.services.organizations.model.PolicyType = software.amazon.awssdk.services.organizations.model.PolicyType.SERVICE_CONTROL_POLICY }
  case object TAG_POLICY extends PolicyType { override def unwrap: software.amazon.awssdk.services.organizations.model.PolicyType = software.amazon.awssdk.services.organizations.model.PolicyType.TAG_POLICY }
  case object BACKUP_POLICY extends PolicyType { override def unwrap: software.amazon.awssdk.services.organizations.model.PolicyType = software.amazon.awssdk.services.organizations.model.PolicyType.BACKUP_POLICY }
  case object AISERVICES_OPT_OUT_POLICY extends PolicyType { override def unwrap: software.amazon.awssdk.services.organizations.model.PolicyType = software.amazon.awssdk.services.organizations.model.PolicyType.AISERVICES_OPT_OUT_POLICY }
}