package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListRootsResponse(roots: scala.Option[Iterable[Root]] = None, nextToken: scala.Option[primitives.NextToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.ListRootsResponse = {
    import ListRootsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListRootsResponse.builder().optionallyWith(roots.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.roots).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListRootsResponse.ReadOnly = ListRootsResponse.wrap(buildAwsValue())
}
object ListRootsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.ListRootsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListRootsResponse = ListRootsResponse(rootsValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def rootsValue: scala.Option[List[Root.ReadOnly]]
    def nextTokenValue: scala.Option[primitives.NextToken]
    def roots: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Root.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("roots", rootsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.ListRootsResponse) extends ListRootsResponse.ReadOnly {
    override def rootsValue: scala.Option[List[Root.ReadOnly]] = scala.Option(impl.roots()).map(value => value.asScala.map { item => 
      Root.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[primitives.NextToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextToken)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.ListRootsResponse): ReadOnly = new Wrapper(impl)
}