package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListAccountsResponse(accounts: scala.Option[Iterable[Account]] = None, nextToken: scala.Option[primitives.NextToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.ListAccountsResponse = {
    import ListAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListAccountsResponse.builder().optionallyWith(accounts.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.accounts).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListAccountsResponse.ReadOnly = ListAccountsResponse.wrap(buildAwsValue())
}
object ListAccountsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.ListAccountsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListAccountsResponse = ListAccountsResponse(accountsValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def accountsValue: scala.Option[List[Account.ReadOnly]]
    def nextTokenValue: scala.Option[primitives.NextToken]
    def accounts: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Account.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accounts", accountsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.ListAccountsResponse) extends ListAccountsResponse.ReadOnly {
    override def accountsValue: scala.Option[List[Account.ReadOnly]] = scala.Option(impl.accounts()).map(value => value.asScala.map { item => 
      Account.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[primitives.NextToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextToken)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.ListAccountsResponse): ReadOnly = new Wrapper(impl)
}