package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeOrganizationalUnitRequest(organizationalUnitId: primitives.OrganizationalUnitId) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitRequest = {
    import DescribeOrganizationalUnitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitRequest.builder().organizationalUnitId(organizationalUnitId: java.lang.String).build()
  }
  def asReadOnly: DescribeOrganizationalUnitRequest.ReadOnly = DescribeOrganizationalUnitRequest.wrap(buildAwsValue())
}
object DescribeOrganizationalUnitRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeOrganizationalUnitRequest = DescribeOrganizationalUnitRequest(organizationalUnitIdValue)
    def organizationalUnitIdValue: primitives.OrganizationalUnitId
    def organizationalUnitId: ZIO[Any, Nothing, primitives.OrganizationalUnitId] = ZIO.succeed(organizationalUnitIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitRequest) extends DescribeOrganizationalUnitRequest.ReadOnly { override def organizationalUnitIdValue: primitives.OrganizationalUnitId = impl.organizationalUnitId(): primitives.OrganizationalUnitId }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitRequest): ReadOnly = new Wrapper(impl)
}