package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateGovCloudAccountRequest(email: primitives.Email, accountName: primitives.AccountName, roleName: scala.Option[primitives.RoleName] = None, iamUserAccessToBilling: scala.Option[IAMUserAccessToBilling] = None, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.CreateGovCloudAccountRequest = {
    import CreateGovCloudAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.CreateGovCloudAccountRequest.builder().email(email: java.lang.String).accountName(accountName: java.lang.String).optionallyWith(roleName.map(value => value: java.lang.String))(_.roleName).optionallyWith(iamUserAccessToBilling.map(value => value.unwrap))(_.iamUserAccessToBilling).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: CreateGovCloudAccountRequest.ReadOnly = CreateGovCloudAccountRequest.wrap(buildAwsValue())
}
object CreateGovCloudAccountRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.CreateGovCloudAccountRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateGovCloudAccountRequest = CreateGovCloudAccountRequest(emailValue, accountNameValue, roleNameValue.map(value => value), iamUserAccessToBillingValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def emailValue: primitives.Email
    def accountNameValue: primitives.AccountName
    def roleNameValue: scala.Option[primitives.RoleName]
    def iamUserAccessToBillingValue: scala.Option[IAMUserAccessToBilling]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def email: ZIO[Any, Nothing, primitives.Email] = ZIO.succeed(emailValue)
    def accountName: ZIO[Any, Nothing, primitives.AccountName] = ZIO.succeed(accountNameValue)
    def roleName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RoleName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("roleName", roleNameValue)
    def iamUserAccessToBilling: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, IAMUserAccessToBilling] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("iamUserAccessToBilling", iamUserAccessToBillingValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.CreateGovCloudAccountRequest) extends CreateGovCloudAccountRequest.ReadOnly {
    override def emailValue: primitives.Email = impl.email(): primitives.Email
    override def accountNameValue: primitives.AccountName = impl.accountName(): primitives.AccountName
    override def roleNameValue: scala.Option[primitives.RoleName] = scala.Option(impl.roleName()).map(value => value: primitives.RoleName)
    override def iamUserAccessToBillingValue: scala.Option[IAMUserAccessToBilling] = scala.Option(impl.iamUserAccessToBilling()).map(value => IAMUserAccessToBilling.wrap(value))
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.CreateGovCloudAccountRequest): ReadOnly = new Wrapper(impl)
}