package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AttachPolicyRequest(policyId: primitives.PolicyId, targetId: primitives.PolicyTargetId) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.AttachPolicyRequest = {
    import AttachPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.AttachPolicyRequest.builder().policyId(policyId: java.lang.String).targetId(targetId: java.lang.String).build()
  }
  def asReadOnly: AttachPolicyRequest.ReadOnly = AttachPolicyRequest.wrap(buildAwsValue())
}
object AttachPolicyRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.AttachPolicyRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AttachPolicyRequest = AttachPolicyRequest(policyIdValue, targetIdValue)
    def policyIdValue: primitives.PolicyId
    def targetIdValue: primitives.PolicyTargetId
    def policyId: ZIO[Any, Nothing, primitives.PolicyId] = ZIO.succeed(policyIdValue)
    def targetId: ZIO[Any, Nothing, primitives.PolicyTargetId] = ZIO.succeed(targetIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.AttachPolicyRequest) extends AttachPolicyRequest.ReadOnly {
    override def policyIdValue: primitives.PolicyId = impl.policyId(): primitives.PolicyId
    override def targetIdValue: primitives.PolicyTargetId = impl.targetId(): primitives.PolicyTargetId
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.AttachPolicyRequest): ReadOnly = new Wrapper(impl)
}