package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribePolicyRequest(policyId: primitives.PolicyId) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.DescribePolicyRequest = {
    import DescribePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DescribePolicyRequest.builder().policyId(policyId: java.lang.String).build()
  }
  def asReadOnly: DescribePolicyRequest.ReadOnly = DescribePolicyRequest.wrap(buildAwsValue())
}
object DescribePolicyRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.DescribePolicyRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribePolicyRequest = DescribePolicyRequest(policyIdValue)
    def policyIdValue: primitives.PolicyId
    def policyId: ZIO[Any, Nothing, primitives.PolicyId] = ZIO.succeed(policyIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.DescribePolicyRequest) extends DescribePolicyRequest.ReadOnly { override def policyIdValue: primitives.PolicyId = impl.policyId(): primitives.PolicyId }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.DescribePolicyRequest): ReadOnly = new Wrapper(impl)
}