package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateOrganizationalUnitResponse(organizationalUnit: scala.Option[OrganizationalUnit] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitResponse = {
    import CreateOrganizationalUnitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitResponse.builder().optionallyWith(organizationalUnit.map(value => value.buildAwsValue()))(_.organizationalUnit).build()
  }
  def asReadOnly: CreateOrganizationalUnitResponse.ReadOnly = CreateOrganizationalUnitResponse.wrap(buildAwsValue())
}
object CreateOrganizationalUnitResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateOrganizationalUnitResponse = CreateOrganizationalUnitResponse(organizationalUnitValue.map(value => value.editable))
    def organizationalUnitValue: scala.Option[OrganizationalUnit.ReadOnly]
    def organizationalUnit: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, OrganizationalUnit.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("organizationalUnit", organizationalUnitValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitResponse) extends CreateOrganizationalUnitResponse.ReadOnly { override def organizationalUnitValue: scala.Option[OrganizationalUnit.ReadOnly] = scala.Option(impl.organizationalUnit()).map(value => OrganizationalUnit.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitResponse): ReadOnly = new Wrapper(impl)
}