package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateOrganizationResponse(organization: scala.Option[Organization] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.CreateOrganizationResponse = {
    import CreateOrganizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.CreateOrganizationResponse.builder().optionallyWith(organization.map(value => value.buildAwsValue()))(_.organization).build()
  }
  def asReadOnly: CreateOrganizationResponse.ReadOnly = CreateOrganizationResponse.wrap(buildAwsValue())
}
object CreateOrganizationResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.CreateOrganizationResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateOrganizationResponse = CreateOrganizationResponse(organizationValue.map(value => value.editable))
    def organizationValue: scala.Option[Organization.ReadOnly]
    def organization: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Organization.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("organization", organizationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.CreateOrganizationResponse) extends CreateOrganizationResponse.ReadOnly { override def organizationValue: scala.Option[Organization.ReadOnly] = scala.Option(impl.organization()).map(value => Organization.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.CreateOrganizationResponse): ReadOnly = new Wrapper(impl)
}