package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DisableAwsServiceAccessRequest(servicePrincipal: primitives.ServicePrincipal) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.DisableAwsServiceAccessRequest = {
    import DisableAwsServiceAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DisableAwsServiceAccessRequest.builder().servicePrincipal(servicePrincipal: java.lang.String).build()
  }
  def asReadOnly: DisableAwsServiceAccessRequest.ReadOnly = DisableAwsServiceAccessRequest.wrap(buildAwsValue())
}
object DisableAwsServiceAccessRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.DisableAwsServiceAccessRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DisableAwsServiceAccessRequest = DisableAwsServiceAccessRequest(servicePrincipalValue)
    def servicePrincipalValue: primitives.ServicePrincipal
    def servicePrincipal: ZIO[Any, Nothing, primitives.ServicePrincipal] = ZIO.succeed(servicePrincipalValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.DisableAwsServiceAccessRequest) extends DisableAwsServiceAccessRequest.ReadOnly { override def servicePrincipalValue: primitives.ServicePrincipal = impl.servicePrincipal(): primitives.ServicePrincipal }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.DisableAwsServiceAccessRequest): ReadOnly = new Wrapper(impl)
}