package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeletePolicyRequest(policyId: primitives.PolicyId) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.DeletePolicyRequest = {
    import DeletePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DeletePolicyRequest.builder().policyId(policyId: java.lang.String).build()
  }
  def asReadOnly: DeletePolicyRequest.ReadOnly = DeletePolicyRequest.wrap(buildAwsValue())
}
object DeletePolicyRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.DeletePolicyRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeletePolicyRequest = DeletePolicyRequest(policyIdValue)
    def policyIdValue: primitives.PolicyId
    def policyId: ZIO[Any, Nothing, primitives.PolicyId] = ZIO.succeed(policyIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.DeletePolicyRequest) extends DeletePolicyRequest.ReadOnly { override def policyIdValue: primitives.PolicyId = impl.policyId(): primitives.PolicyId }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.DeletePolicyRequest): ReadOnly = new Wrapper(impl)
}