package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Account(id: scala.Option[primitives.AccountId] = None, arn: scala.Option[primitives.AccountArn] = None, email: scala.Option[primitives.Email] = None, name: scala.Option[primitives.AccountName] = None, status: scala.Option[AccountStatus] = None, joinedMethod: scala.Option[AccountJoinedMethod] = None, joinedTimestamp: scala.Option[primitives.Timestamp] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.Account = {
    import Account.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.Account.builder().optionallyWith(id.map(value => value: java.lang.String))(_.id).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(email.map(value => value: java.lang.String))(_.email).optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(status.map(value => value.unwrap))(_.status).optionallyWith(joinedMethod.map(value => value.unwrap))(_.joinedMethod).optionallyWith(joinedTimestamp.map(value => value: java.time.Instant))(_.joinedTimestamp).build()
  }
  def asReadOnly: Account.ReadOnly = Account.wrap(buildAwsValue())
}
object Account {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.Account] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Account = Account(idValue.map(value => value), arnValue.map(value => value), emailValue.map(value => value), nameValue.map(value => value), statusValue.map(value => value), joinedMethodValue.map(value => value), joinedTimestampValue.map(value => value))
    def idValue: scala.Option[primitives.AccountId]
    def arnValue: scala.Option[primitives.AccountArn]
    def emailValue: scala.Option[primitives.Email]
    def nameValue: scala.Option[primitives.AccountName]
    def statusValue: scala.Option[AccountStatus]
    def joinedMethodValue: scala.Option[AccountJoinedMethod]
    def joinedTimestampValue: scala.Option[primitives.Timestamp]
    def id: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AccountId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("id", idValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AccountArn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def email: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Email] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("email", emailValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AccountName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AccountStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    def joinedMethod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AccountJoinedMethod] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("joinedMethod", joinedMethodValue)
    def joinedTimestamp: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Timestamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("joinedTimestamp", joinedTimestampValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.Account) extends Account.ReadOnly {
    override def idValue: scala.Option[primitives.AccountId] = scala.Option(impl.id()).map(value => value: primitives.AccountId)
    override def arnValue: scala.Option[primitives.AccountArn] = scala.Option(impl.arn()).map(value => value: primitives.AccountArn)
    override def emailValue: scala.Option[primitives.Email] = scala.Option(impl.email()).map(value => value: primitives.Email)
    override def nameValue: scala.Option[primitives.AccountName] = scala.Option(impl.name()).map(value => value: primitives.AccountName)
    override def statusValue: scala.Option[AccountStatus] = scala.Option(impl.status()).map(value => AccountStatus.wrap(value))
    override def joinedMethodValue: scala.Option[AccountJoinedMethod] = scala.Option(impl.joinedMethod()).map(value => AccountJoinedMethod.wrap(value))
    override def joinedTimestampValue: scala.Option[primitives.Timestamp] = scala.Option(impl.joinedTimestamp()).map(value => value: primitives.Timestamp)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.Account): ReadOnly = new Wrapper(impl)
}