package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateOrganizationalUnitResponse(organizationalUnit: scala.Option[OrganizationalUnit] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitResponse = {
    import UpdateOrganizationalUnitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitResponse.builder().optionallyWith(organizationalUnit.map(value => value.buildAwsValue()))(_.organizationalUnit).build()
  }
  def asReadOnly: UpdateOrganizationalUnitResponse.ReadOnly = UpdateOrganizationalUnitResponse.wrap(buildAwsValue())
}
object UpdateOrganizationalUnitResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateOrganizationalUnitResponse = UpdateOrganizationalUnitResponse(organizationalUnitValue.map(value => value.editable))
    def organizationalUnitValue: scala.Option[OrganizationalUnit.ReadOnly]
    def organizationalUnit: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, OrganizationalUnit.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("organizationalUnit", organizationalUnitValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitResponse) extends UpdateOrganizationalUnitResponse.ReadOnly { override def organizationalUnitValue: scala.Option[OrganizationalUnit.ReadOnly] = scala.Option(impl.organizationalUnit()).map(value => OrganizationalUnit.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitResponse): ReadOnly = new Wrapper(impl)
}