package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Organization(id: scala.Option[primitives.OrganizationId] = None, arn: scala.Option[primitives.OrganizationArn] = None, featureSet: scala.Option[OrganizationFeatureSet] = None, masterAccountArn: scala.Option[primitives.AccountArn] = None, masterAccountId: scala.Option[primitives.AccountId] = None, masterAccountEmail: scala.Option[primitives.Email] = None, availablePolicyTypes: scala.Option[Iterable[PolicyTypeSummary]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.Organization = {
    import Organization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.Organization.builder().optionallyWith(id.map(value => value: java.lang.String))(_.id).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(featureSet.map(value => value.unwrap))(_.featureSet).optionallyWith(masterAccountArn.map(value => value: java.lang.String))(_.masterAccountArn).optionallyWith(masterAccountId.map(value => value: java.lang.String))(_.masterAccountId).optionallyWith(masterAccountEmail.map(value => value: java.lang.String))(_.masterAccountEmail).optionallyWith(availablePolicyTypes.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.availablePolicyTypes).build()
  }
  def asReadOnly: Organization.ReadOnly = Organization.wrap(buildAwsValue())
}
object Organization {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.Organization] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Organization = Organization(idValue.map(value => value), arnValue.map(value => value), featureSetValue.map(value => value), masterAccountArnValue.map(value => value), masterAccountIdValue.map(value => value), masterAccountEmailValue.map(value => value), availablePolicyTypesValue.map(value => value.map { item => 
      item.editable
    }))
    def idValue: scala.Option[primitives.OrganizationId]
    def arnValue: scala.Option[primitives.OrganizationArn]
    def featureSetValue: scala.Option[OrganizationFeatureSet]
    def masterAccountArnValue: scala.Option[primitives.AccountArn]
    def masterAccountIdValue: scala.Option[primitives.AccountId]
    def masterAccountEmailValue: scala.Option[primitives.Email]
    def availablePolicyTypesValue: scala.Option[List[PolicyTypeSummary.ReadOnly]]
    def id: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OrganizationId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("id", idValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OrganizationArn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def featureSet: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, OrganizationFeatureSet] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("featureSet", featureSetValue)
    def masterAccountArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AccountArn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterAccountArn", masterAccountArnValue)
    def masterAccountId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AccountId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterAccountId", masterAccountIdValue)
    def masterAccountEmail: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Email] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterAccountEmail", masterAccountEmailValue)
    def availablePolicyTypes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[PolicyTypeSummary.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availablePolicyTypes", availablePolicyTypesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.Organization) extends Organization.ReadOnly {
    override def idValue: scala.Option[primitives.OrganizationId] = scala.Option(impl.id()).map(value => value: primitives.OrganizationId)
    override def arnValue: scala.Option[primitives.OrganizationArn] = scala.Option(impl.arn()).map(value => value: primitives.OrganizationArn)
    override def featureSetValue: scala.Option[OrganizationFeatureSet] = scala.Option(impl.featureSet()).map(value => OrganizationFeatureSet.wrap(value))
    override def masterAccountArnValue: scala.Option[primitives.AccountArn] = scala.Option(impl.masterAccountArn()).map(value => value: primitives.AccountArn)
    override def masterAccountIdValue: scala.Option[primitives.AccountId] = scala.Option(impl.masterAccountId()).map(value => value: primitives.AccountId)
    override def masterAccountEmailValue: scala.Option[primitives.Email] = scala.Option(impl.masterAccountEmail()).map(value => value: primitives.Email)
    override def availablePolicyTypesValue: scala.Option[List[PolicyTypeSummary.ReadOnly]] = scala.Option(impl.availablePolicyTypes()).map(value => value.asScala.map { item => 
      PolicyTypeSummary.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.Organization): ReadOnly = new Wrapper(impl)
}