package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListTargetsForPolicyResponse(targets: scala.Option[Iterable[PolicyTargetSummary]] = None, nextToken: scala.Option[primitives.NextToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyResponse = {
    import ListTargetsForPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyResponse.builder().optionallyWith(targets.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.targets).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListTargetsForPolicyResponse.ReadOnly = ListTargetsForPolicyResponse.wrap(buildAwsValue())
}
object ListTargetsForPolicyResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListTargetsForPolicyResponse = ListTargetsForPolicyResponse(targetsValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def targetsValue: scala.Option[List[PolicyTargetSummary.ReadOnly]]
    def nextTokenValue: scala.Option[primitives.NextToken]
    def targets: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[PolicyTargetSummary.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("targets", targetsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyResponse) extends ListTargetsForPolicyResponse.ReadOnly {
    override def targetsValue: scala.Option[List[PolicyTargetSummary.ReadOnly]] = scala.Option(impl.targets()).map(value => value.asScala.map { item => 
      PolicyTargetSummary.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[primitives.NextToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextToken)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyResponse): ReadOnly = new Wrapper(impl)
}