package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListOrganizationalUnitsForParentRequest(parentId: primitives.ParentId, nextToken: scala.Option[primitives.NextToken] = None, maxResults: scala.Option[primitives.MaxResults] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentRequest = {
    import ListOrganizationalUnitsForParentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentRequest.builder().parentId(parentId: java.lang.String).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).build()
  }
  def asReadOnly: ListOrganizationalUnitsForParentRequest.ReadOnly = ListOrganizationalUnitsForParentRequest.wrap(buildAwsValue())
}
object ListOrganizationalUnitsForParentRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListOrganizationalUnitsForParentRequest = ListOrganizationalUnitsForParentRequest(parentIdValue, nextTokenValue.map(value => value), maxResultsValue.map(value => value))
    def parentIdValue: primitives.ParentId
    def nextTokenValue: scala.Option[primitives.NextToken]
    def maxResultsValue: scala.Option[primitives.MaxResults]
    def parentId: ZIO[Any, Nothing, primitives.ParentId] = ZIO.succeed(parentIdValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResults] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentRequest) extends ListOrganizationalUnitsForParentRequest.ReadOnly {
    override def parentIdValue: primitives.ParentId = impl.parentId(): primitives.ParentId
    override def nextTokenValue: scala.Option[primitives.NextToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextToken)
    override def maxResultsValue: scala.Option[primitives.MaxResults] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResults)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentRequest): ReadOnly = new Wrapper(impl)
}