package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class EnablePolicyTypeRequest(rootId: primitives.RootId, policyType: PolicyType) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.EnablePolicyTypeRequest = {
    import EnablePolicyTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.EnablePolicyTypeRequest.builder().rootId(rootId: java.lang.String).policyType(policyType.unwrap).build()
  }
  def asReadOnly: EnablePolicyTypeRequest.ReadOnly = EnablePolicyTypeRequest.wrap(buildAwsValue())
}
object EnablePolicyTypeRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.EnablePolicyTypeRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: EnablePolicyTypeRequest = EnablePolicyTypeRequest(rootIdValue, policyTypeValue)
    def rootIdValue: primitives.RootId
    def policyTypeValue: PolicyType
    def rootId: ZIO[Any, Nothing, primitives.RootId] = ZIO.succeed(rootIdValue)
    def policyType: ZIO[Any, Nothing, PolicyType] = ZIO.succeed(policyTypeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.EnablePolicyTypeRequest) extends EnablePolicyTypeRequest.ReadOnly {
    override def rootIdValue: primitives.RootId = impl.rootId(): primitives.RootId
    override def policyTypeValue: PolicyType = PolicyType.wrap(impl.policyType())
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.EnablePolicyTypeRequest): ReadOnly = new Wrapper(impl)
}