package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class EnableAwsServiceAccessRequest(servicePrincipal: primitives.ServicePrincipal) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.EnableAwsServiceAccessRequest = {
    import EnableAwsServiceAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.EnableAwsServiceAccessRequest.builder().servicePrincipal(servicePrincipal: java.lang.String).build()
  }
  def asReadOnly: EnableAwsServiceAccessRequest.ReadOnly = EnableAwsServiceAccessRequest.wrap(buildAwsValue())
}
object EnableAwsServiceAccessRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.EnableAwsServiceAccessRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: EnableAwsServiceAccessRequest = EnableAwsServiceAccessRequest(servicePrincipalValue)
    def servicePrincipalValue: primitives.ServicePrincipal
    def servicePrincipal: ZIO[Any, Nothing, primitives.ServicePrincipal] = ZIO.succeed(servicePrincipalValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.EnableAwsServiceAccessRequest) extends EnableAwsServiceAccessRequest.ReadOnly { override def servicePrincipalValue: primitives.ServicePrincipal = impl.servicePrincipal(): primitives.ServicePrincipal }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.EnableAwsServiceAccessRequest): ReadOnly = new Wrapper(impl)
}