package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeHandshakeRequest(handshakeId: primitives.HandshakeId) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.DescribeHandshakeRequest = {
    import DescribeHandshakeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DescribeHandshakeRequest.builder().handshakeId(handshakeId: java.lang.String).build()
  }
  def asReadOnly: DescribeHandshakeRequest.ReadOnly = DescribeHandshakeRequest.wrap(buildAwsValue())
}
object DescribeHandshakeRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.DescribeHandshakeRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeHandshakeRequest = DescribeHandshakeRequest(handshakeIdValue)
    def handshakeIdValue: primitives.HandshakeId
    def handshakeId: ZIO[Any, Nothing, primitives.HandshakeId] = ZIO.succeed(handshakeIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.DescribeHandshakeRequest) extends DescribeHandshakeRequest.ReadOnly { override def handshakeIdValue: primitives.HandshakeId = impl.handshakeId(): primitives.HandshakeId }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.DescribeHandshakeRequest): ReadOnly = new Wrapper(impl)
}