package io.github.vigoo.zioaws.organizations
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
package object model {
  object primitives {
    type AccountArn = String
    type AccountId = String
    type AccountName = String
    type AwsManagedPolicy = Boolean
    type ChildId = String
    type CreateAccountRequestId = String
    type Email = String
    type GenericArn = String
    type HandshakeArn = String
    type HandshakeId = String
    type HandshakeNotes = String
    type HandshakePartyId = String
    type HandshakeResourceValue = String
    type MaxResults = Int
    type NextToken = String
    type OrganizationArn = String
    type OrganizationId = String
    type OrganizationalUnitArn = String
    type OrganizationalUnitId = String
    type OrganizationalUnitName = String
    type ParentId = String
    type PolicyArn = String
    type PolicyContent = String
    type PolicyDescription = String
    type PolicyId = String
    type PolicyName = String
    type PolicyTargetId = String
    type RoleName = String
    type RootArn = String
    type RootId = String
    type RootName = String
    type ServicePrincipal = String
    type TagKey = String
    type TagValue = String
    type TaggableResourceId = String
    type TargetName = String
    type Timestamp = Instant
  }
  type Accounts = List[Account]
  type Children = List[Child]
  type CreateAccountStates = List[CreateAccountState]
  type CreateAccountStatuses = List[CreateAccountStatus]
  type DelegatedAdministrators = List[DelegatedAdministrator]
  type DelegatedServices = List[DelegatedService]
  type EnabledServicePrincipals = List[EnabledServicePrincipal]
  type HandshakeParties = List[HandshakeParty]
  type HandshakeResources = List[HandshakeResource]
  type Handshakes = List[Handshake]
  type OrganizationalUnits = List[OrganizationalUnit]
  type Parents = List[Parent]
  type Policies = List[PolicySummary]
  type PolicyTargets = List[PolicyTargetSummary]
  type PolicyTypes = List[PolicyTypeSummary]
  type Roots = List[Root]
  type TagKeys = List[primitives.TagKey]
  type Tags = List[Tag]
}