package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class TagResourceRequest(resourceId: primitives.TaggableResourceId, tags: Iterable[Tag]) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.TagResourceRequest.builder().resourceId(resourceId: java.lang.String).tags(tags.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).build()
  }
  def asReadOnly: TagResourceRequest.ReadOnly = TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.TagResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: TagResourceRequest = TagResourceRequest(resourceIdValue, tagsValue.map { item => 
      item.editable
    })
    def resourceIdValue: primitives.TaggableResourceId
    def tagsValue: List[Tag.ReadOnly]
    def resourceId: ZIO[Any, Nothing, primitives.TaggableResourceId] = ZIO.succeed(resourceIdValue)
    def tags: ZIO[Any, Nothing, List[Tag.ReadOnly]] = ZIO.succeed(tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.TagResourceRequest) extends TagResourceRequest.ReadOnly {
    override def resourceIdValue: primitives.TaggableResourceId = impl.resourceId(): primitives.TaggableResourceId
    override def tagsValue: List[Tag.ReadOnly] = impl.tags().asScala.map { item => 
      Tag.wrap(item)
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.TagResourceRequest): ReadOnly = new Wrapper(impl)
}