package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Tag(key: primitives.TagKey, value: primitives.TagValue) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.Tag.builder().key(key: java.lang.String).value(value: java.lang.String).build()
  }
  def asReadOnly: Tag.ReadOnly = Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.Tag] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Tag = Tag(keyValue, valueValue)
    def keyValue: primitives.TagKey
    def valueValue: primitives.TagValue
    def key: ZIO[Any, Nothing, primitives.TagKey] = ZIO.succeed(keyValue)
    def value: ZIO[Any, Nothing, primitives.TagValue] = ZIO.succeed(valueValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.Tag) extends Tag.ReadOnly {
    override def keyValue: primitives.TagKey = impl.key(): primitives.TagKey
    override def valueValue: primitives.TagValue = impl.value(): primitives.TagValue
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.Tag): ReadOnly = new Wrapper(impl)
}