package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class PolicyTargetSummary(targetId: scala.Option[primitives.PolicyTargetId] = None, arn: scala.Option[primitives.GenericArn] = None, name: scala.Option[primitives.TargetName] = None, `type`: scala.Option[TargetType] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.PolicyTargetSummary = {
    import PolicyTargetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.PolicyTargetSummary.builder().optionallyWith(targetId.map(value => value: java.lang.String))(_.targetId).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(`type`.map(value => value.unwrap))(_.`type`).build()
  }
  def asReadOnly: PolicyTargetSummary.ReadOnly = PolicyTargetSummary.wrap(buildAwsValue())
}
object PolicyTargetSummary {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.PolicyTargetSummary] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: PolicyTargetSummary = PolicyTargetSummary(targetIdValue.map(value => value), arnValue.map(value => value), nameValue.map(value => value), typeValue.map(value => value))
    def targetIdValue: scala.Option[primitives.PolicyTargetId]
    def arnValue: scala.Option[primitives.GenericArn]
    def nameValue: scala.Option[primitives.TargetName]
    def typeValue: scala.Option[TargetType]
    def targetId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PolicyTargetId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("targetId", targetIdValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GenericArn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TargetName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def `type`: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, TargetType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("type", typeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.PolicyTargetSummary) extends PolicyTargetSummary.ReadOnly {
    override def targetIdValue: scala.Option[primitives.PolicyTargetId] = scala.Option(impl.targetId()).map(value => value: primitives.PolicyTargetId)
    override def arnValue: scala.Option[primitives.GenericArn] = scala.Option(impl.arn()).map(value => value: primitives.GenericArn)
    override def nameValue: scala.Option[primitives.TargetName] = scala.Option(impl.name()).map(value => value: primitives.TargetName)
    override def typeValue: scala.Option[TargetType] = scala.Option(impl.`type`()).map(value => TargetType.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.PolicyTargetSummary): ReadOnly = new Wrapper(impl)
}