package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListTargetsForPolicyRequest(policyId: primitives.PolicyId, nextToken: scala.Option[primitives.NextToken] = None, maxResults: scala.Option[primitives.MaxResults] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyRequest = {
    import ListTargetsForPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyRequest.builder().policyId(policyId: java.lang.String).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).build()
  }
  def asReadOnly: ListTargetsForPolicyRequest.ReadOnly = ListTargetsForPolicyRequest.wrap(buildAwsValue())
}
object ListTargetsForPolicyRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListTargetsForPolicyRequest = ListTargetsForPolicyRequest(policyIdValue, nextTokenValue.map(value => value), maxResultsValue.map(value => value))
    def policyIdValue: primitives.PolicyId
    def nextTokenValue: scala.Option[primitives.NextToken]
    def maxResultsValue: scala.Option[primitives.MaxResults]
    def policyId: ZIO[Any, Nothing, primitives.PolicyId] = ZIO.succeed(policyIdValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResults] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyRequest) extends ListTargetsForPolicyRequest.ReadOnly {
    override def policyIdValue: primitives.PolicyId = impl.policyId(): primitives.PolicyId
    override def nextTokenValue: scala.Option[primitives.NextToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextToken)
    override def maxResultsValue: scala.Option[primitives.MaxResults] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResults)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyRequest): ReadOnly = new Wrapper(impl)
}