package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListTagsForResourceRequest(resourceId: primitives.TaggableResourceId, nextToken: scala.Option[primitives.NextToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListTagsForResourceRequest.builder().resourceId(resourceId: java.lang.String).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListTagsForResourceRequest.ReadOnly = ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.ListTagsForResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListTagsForResourceRequest = ListTagsForResourceRequest(resourceIdValue, nextTokenValue.map(value => value))
    def resourceIdValue: primitives.TaggableResourceId
    def nextTokenValue: scala.Option[primitives.NextToken]
    def resourceId: ZIO[Any, Nothing, primitives.TaggableResourceId] = ZIO.succeed(resourceIdValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.ListTagsForResourceRequest) extends ListTagsForResourceRequest.ReadOnly {
    override def resourceIdValue: primitives.TaggableResourceId = impl.resourceId(): primitives.TaggableResourceId
    override def nextTokenValue: scala.Option[primitives.NextToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextToken)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.ListTagsForResourceRequest): ReadOnly = new Wrapper(impl)
}