package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListPoliciesForTargetRequest(targetId: primitives.PolicyTargetId, filter: PolicyType, nextToken: scala.Option[primitives.NextToken] = None, maxResults: scala.Option[primitives.MaxResults] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetRequest = {
    import ListPoliciesForTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetRequest.builder().targetId(targetId: java.lang.String).filter(filter.unwrap).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).build()
  }
  def asReadOnly: ListPoliciesForTargetRequest.ReadOnly = ListPoliciesForTargetRequest.wrap(buildAwsValue())
}
object ListPoliciesForTargetRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListPoliciesForTargetRequest = ListPoliciesForTargetRequest(targetIdValue, filterValue, nextTokenValue.map(value => value), maxResultsValue.map(value => value))
    def targetIdValue: primitives.PolicyTargetId
    def filterValue: PolicyType
    def nextTokenValue: scala.Option[primitives.NextToken]
    def maxResultsValue: scala.Option[primitives.MaxResults]
    def targetId: ZIO[Any, Nothing, primitives.PolicyTargetId] = ZIO.succeed(targetIdValue)
    def filter: ZIO[Any, Nothing, PolicyType] = ZIO.succeed(filterValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResults] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetRequest) extends ListPoliciesForTargetRequest.ReadOnly {
    override def targetIdValue: primitives.PolicyTargetId = impl.targetId(): primitives.PolicyTargetId
    override def filterValue: PolicyType = PolicyType.wrap(impl.filter())
    override def nextTokenValue: scala.Option[primitives.NextToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextToken)
    override def maxResultsValue: scala.Option[primitives.MaxResults] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResults)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetRequest): ReadOnly = new Wrapper(impl)
}